/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/

using Inet.Viewer.Data;
namespace Inet.Viewer
{
    /// <summary>
    /// Interface for receiving the results of a search.
    /// </summary>
    public interface ISearchResultReceiver
    {
        /// <summary>
        /// This method is called during the search itself: a search result is defined by its pre-context, its actual result
        /// string (which might be different from the search term, for example if the term was a regular expression), its
        /// post-context, and its individual search chunks. </summary>
        /// <param name="pre"> Pre-Context of the result </param>
        /// <param name="result"> Result itself </param>
        /// <param name="post"> Post-context of the result </param>
        /// <param name="chunks"> Individual SearchChunk objects of this result (containing the position of the various
        /// SearchChunks of this result) </param>
        void AddSearchResult(string pre, string result, string post, SearchChunk[] chunks);

        /// <summary>
        /// This method is called at the end of a search as the last call: This is meant to update the
        /// list of search results as well as verify the search has been finished not. </summary>
        /// <param name="page"> Page the search was discontinued, if any. <code>-1</code> if the search is finished. </param>
        /// <param name="timestamp"> the latest timestamp of the report this search was performed on. </param>
        void EndSearch(int page, long timestamp);

        /// <summary>
        /// This method is called if the search has been manually canceled by the user.
        /// </summary>
        void CancelSearch();
    }
}